<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user has permission to manage roles
if (!hasPermission('manage_roles')) {
    http_response_code(403);
    echo json_encode(['error' => 'Permission denied']);
    exit;
}

// Check if role_id is provided
if (!isset($_GET['role_id']) || !is_numeric($_GET['role_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid role ID']);
    exit;
}

$role_id = intval($_GET['role_id']);

try {
    // Get permissions for the specified role
    $stmt = $pdo->prepare("
        SELECT permission_id 
        FROM role_permissions 
        WHERE role_id = ?
    ");
    $stmt->execute([$role_id]);
    $permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Return permissions as JSON
    header('Content-Type: application/json');
    echo json_encode($permissions);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?> 